<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$users = [];
$error = '';

try {
    $conn = getAdminDBConnection();

    // Fetch all users
    $stmt = $conn->prepare("SELECT id, username, full_name, email, balance, role, created_at FROM users ORDER BY created_at DESC");
    if ($stmt === false) {
        throw new Exception('Prepare users statement failed: ' . $conn->error);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $users[] = $row;
        }
    }
    $stmt->close();

} catch (Exception $e) {
    $error = 'حدث خطأ أثناء تحميل بيانات المستخدمين: ' . $e->getMessage();
}

require_once '../header.php'; // Include header for consistent styling
?>

<div class="container bg-dark text-white mt-5">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="mb-0">إدارة المستخدمين</h3>
            <a href="admin_add_user.php" class="btn btn-primary btn-sm">إضافة مستخدم جديد</a>
        </div>
        <div class="card-body">
            <?php 
            $message = $_GET['message'] ?? '';
            $message_type = $_GET['type'] ?? '';
            if (!empty($message)): ?>
                <div class="alert alert-<?= htmlspecialchars($message_type) ?>" role="alert">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>
            <?php if (isset($error)): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>اسم المستخدم</th>
                            <th>الاسم الكامل</th>
                            <th>البريد الإلكتروني</th>
                            <th>الرصيد</th>
                            <th>الدور</th>
                            <th>تاريخ الانضمام</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($users)): ?>
                            <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?= htmlspecialchars($user['id'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($user['username'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($user['full_name'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($user['email'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($user['balance'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($user['role'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($user['created_at'] ?? 'N/A') ?></td>
                                <td>
                                    <a href="admin_edit_user.php?id=<?= htmlspecialchars($user['id'] ?? '') ?>" class="btn btn-sm btn-info">تعديل</a>
                                    <a href="admin_delete_user.php?id=<?= htmlspecialchars($user['id'] ?? '') ?>" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد أنك تريد حذف هذا المستخدم؟');">حذف</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">لا توجد مستخدمين لعرضهم.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once '../footer.php'; ?>
